%global momorel 2

Summary: A Linux video stream processing utility.
Name: transcode
Version: 0.6.12
Release: %{momorel}m
License: GPL
Group: Applications/Multimedia
URL: http://www.theorie.physik.uni-goettingen.de/~ostreich/transcode/
#URL: http://zebra.fh-weingarten.de/~transcode/
%NoSource 0 http://www.zebra.fh-weingarten.de/~transcode/pre/%{name}-%{version}.tar.bz2 af494438ceb22fff46998fa2c7c09a85
BuildRequires: avifile >= 0.7.38 mjpegtools-devel a52dec-devel lzo-devel
BuildRequires: lame-devel >= 3.89 xvid
BuildRequires: libdvdread-devel libdv-devel libogg-devel libvorbis-devel
BuildRequires: ImageMagick-devel >= 5.4.3 SDL-devel >= 1.1.6 libxml2-devel
BuildRequires: libjpeg-devel libfame-devel mplayer
Requires: mjpegtools a52dec xvid
BuildRoot: %{_tmppath}/%{name}-%{version}-root

%description
transcode is a linux text-console utility for video stream processing,
running on a platform that supports shared libraries and threads.  Decoding
and encoding is done by loading modules that are responsible for feeding
transcode with raw video/audio streams (import modules) and encoding the
frames (export modules). It supports elementary video and audio frame
transformations, including de-interlacing or fast resizing of video frames
and loading of external filters.

A number of modules are included to enable import of DVDs on-the-fly, MPEG
elementary (ES) or program streams (VOB), MPEG video, Digital Video (DV),
YUV4MPEG streams, NuppelVideo file format and raw or compressed
(pass-through) video frames and export modules for writing DivX;-), DivX
4.02/5.xx, XviD, Digital Video, MPEG-1/2 or uncompressed AVI files with
MPEG, AC3 (pass-through) or PCM audio.  More file formats and codecs for
audio/video import are supported by the avifile library import module, the
export with avifile is restricted to video codecs only, with MPEG/PCM or AC3
(pass-through) audio provided by transcode. Limited Quicktime export support
and DVD subtitle rendering is also avaliable.

It's modular concept is intended to provide flexibility and easy user
extensibility to include other video/audio codecs or file types.  A set of
tools is available to extract, demultiplex and decode the sources into raw
video/audio streams for import, non AVI-file export modules for writing
single frames (PPM) or YUV4MPEG streams, auto-probing and scanning your
sources and to enable post-processing of AVI files, including header fixing,
merging multiple files or splitting large AVI files to fit on a CD.

More information and usage examples can be found on the original author's
home page at

  http://www.theorie.physik.uni-goettingen.de/~ostreich/transcode/

Written by Thomas streich <ostreich@theorie.physik.uni-goettingen.de>
Currently maintained by Tilmann Bitterberg <transcode@tibit.org>
See the Authors file for contributions from the linux community.
See the file COPYING for license details.

%prep
%setup -q 

%build
%configure --enable-warnings=no
%make 

%install
rm -rf %{buildroot}
%makeinstall transform='s,x,x,'

%clean
#rm -rf %{buildroot}

%files
%defattr(-, root, root)
%doc AUTHORS COPYING ChangeLog README TODO docs/*
%{_bindir}/*
%{_libdir}/transcode
%{_mandir}/man1/*
/usr/share/doc/transcode/*
/usr/share/doc/transcode/html/*


%changelog
* Sun May  2 2004 Masayuki SANO <nosanosa@momonga-linux.org>
- (0.6.12-2m)
- rebuild agaist xvid-1.0.0rc4 (apiversion 4)

* Thu Apr 29 2004 Masayuki SANO <nosanosa@momonga-linux.org>
- (0.6.12-1m)
- version 0.6.12 has been released

* Thu Jan  8 2004 Masayuki SANO <nosanosa@momonga-linux.org>
- (0.6.11-2m)
- add BuildPrereq: mplayer 
- - for building mplayer postprocessing filter plugin(filter_pp.so)

* Sat Nov  8 2003 Kazuhiko <kazuhiko@fdiary.net>
- (0.6.11-1m)
- major feature enhancements

* Sun Oct 19 2003 Kazuhiko <kazuhiko@fdiary.net>
- (0.6.10-2m)
- rebuild against ImageMagkck-5.5.7

* Thu Sep 11 2003 Masayuki SANO <sano@acs.i.kyoto-u.ac.jp>
- (0.6.10-1m)
- version 0.6.10
- Minor feature enhancements

* Thu Sep  4 2003 Kazuhiko <kazuhiko@fdiary.net>
- (0.6.9-2m)
- remove implicit requirements

* Thu Sep  4 2003 Masayuki SANO <sano@acs.i.kyoto-u.ac.jp>
- (0.6.9-1m)
- first import to Momonga

* Thu Aug 21 2003 Masayuki SANO <sano@acs.i.kyoto-u.ac.jp>
- (0.6.9-0.0.1m)
- version 0.6.9

* Thu Jul 24 2003 Masayuki SANO <sano@acs.i.kyoto-u.ac.jp>
- (0.6.8-0.0.1m)

* Sat May 31 2003 Masayuki SANO <sano@acs.i.kyoto-u.ac.jp>
- (0.6.7-0.0.1m)

* Mon Feb 3 2003 Masayuki SANO <sano@acs.i.kyoto-u.ac.jp>
- (0.6.3-0.0.1m)
- version 0.6.3
- enable avifile support

* Mon Jan 20 2003 Masayuki SANO <sano@acs.i.kyoto-u.ac.jp>
- (0.6.3-0.0.0.20021219.1m)
- build for Momonga Linux
- --with-avifile-mods=no because "yes" causes a compile error by avifile
- --enable-warnings=no and Patch0 because trivial error stops a build process...

* Fri Nov 8 2002 Masayuki SANO <sano@acs.i.kyoto-u.ac.jp>
- (0.6.2-0.20021024.1m)
- modified src.rpm of version 0.6.0 at freshrpms.net

* Fri Aug  2 2002 Matthias Saou <matthias.saou@est.une.marmotte.net>
- Update to 0.6.0 final!

* Thu Aug  1 2002 Matthias Saou <matthias.saou@est.une.marmotte.net>
- Update to 0.6.0rc4... doesn't compile :-(
- Added libdv, libogg and libvorbis dependencies.

* Fri Jun 14 2002 Matthias Saou <matthias.saou@est.une.marmotte.net>
- Update to 0.6.0rc1.
- Spec file updates and fixes.

* Mon Dec 24 2001 Matthias Saou <matthias.saou@est.une.marmotte.net>
- Update to 0.5.3.

* Sun Dec  2 2001 Matthias Saou <matthias.saou@est.une.marmotte.net>
- Update to 0.5.1.

* Sun Nov 25 2001 Matthias Saou <matthias.saou@est.une.marmotte.net>
- Major spec file cleanup.

* Wed Jul 11 2001 Thomas streich
- update to transcode v0.3.3
- small changes suggested by VM

* Tue Jul 10 2001 Thomas streich
- update to transcode v0.3.2
- added pkgdir in install section

* Tue Jul 10 2001 Volker Moell <moell@gmx.de>
- Wrote this specfile; first build

