%define momorel 4

Summary: Mono Runtime.
Name: mono
Version: 0.19
Release: %{momorel}m
License: LGPL and GPL
Group: System Environment/Base
Source: http://go-mono.org/archive/mono-%{version}.tar.gz
Source1: http://go-mono.org/archive/mcs-%{version}.tar.gz
NoSource:0
NoSource:1
Patch: mcs.patch
URL: http://www.go-mono.com/
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Requires: /sbin/ldconfig
BuildPrereq: glib >= 1.3.11
BuildPrereq: pkgconfig
BuildPrereq: bison
#BuildPrereq: gc-devel

%description
Mono is an implementation of the ECMA Common Language Insfrastructure,
it contains both a just-in-time compiler for maximum performance, and
an interpeter.  It can also be used to run programs from the .NET
Framework.

%package devel
Summary: Tools required to embed the Mono runtime.
Group: Development/Tools
PreReq: %{name} = %{version}-%{release}
Requires: pkgconfig
Requires: glib-devel
#Requires: gc-devel

%description devel
Header files and libraries used to embed the Mono runtime in an application.

%prep
%setup -q -a1
%patch -p0 -b .makefile

%build
export CC="cc -gdwarf-2"
./configure --prefix=%{_prefix} --sysconfdir=%{_sysconfdir} --with-gc=none
make
pushd mcs-%{version}
export MONO_PATH="`pwd`/../runtime"
make -f makefile.gnu MCS="`pwd`/../mono/jit/mono `pwd`/../runtime/mcs.exe" boot
mv mcs/mcs.exe .
make -f makefile.gnu clean
make -f makefile.gnu RUNTIME="" MCS="`pwd`/../mono/jit/mono `pwd`/mcs.exe"
popd

%install
rm -rf %{buildroot}
%makeinstall
rm -f %{buildroot}%{_libdir}/*.dll
rm -f %{buildroot}%{_bindir}/*.exe
pushd mcs-%{version}
export MONO_PATH="`pwd`/../runtime"
make -f makefile.gnu install prefix=%{buildroot}%{_prefix} MCS="`pwd`/../mono/jit/mono `pwd`/mcs.exe"
for i in AUTHORS COPYING ChangeLog README; do
  cp $i ../$i.mcs
done
popd

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%changelog
* Sun Oct 12 2003 Ryu SASAOKA <ryu@momonga-linux.org>
- (0.19-4m)
- adapt the License: preamble for the Momonga Linux license
  expression unification policy (draft)

* Sun Apr  6 2003 OZAWA Sakuro <crouton@momonga-linux.org>
- (0.19-3m)
- disable gc to avoid build error (other solution?).

* Sat Jan 25 2003 Shingo Akagaki <dora@kitty.dnsalias.org>
- (0.19-2m)
- build mcs and replace runtime.

* Sat Jan 25 2003 Shingo Akagaki <dora@kitty.dnsalias.org>
- (0.19-1m)
- version 0.19

* Sat Jan 25 2003 Nguyen Hung Vu <vuhung@mononga-linux.org>
- Nguyen Hung Vu (0.18-2m)
- Update URLs

* Fri Jan 17 2003 Nguyen Hung Vu <vuhung@momonga-linux.org>
- Nguyen Hung Vu (0.18-1m)
- First rebuild from Momonga

%files
%defattr(-, root, root)
%doc AUTHORS COPYING.LIB ChangeLog NEWS README
%doc AUTHORS.mcs COPYING.mcs ChangeLog.mcs README.mcs
%dir %{_sysconfdir}/mono
%{_sysconfdir}/mono/config
%{_sysconfdir}/mono/machine.config
%{_bindir}/*
%{_libdir}/*.so.*
%{_libdir}/*.dll
%{_mandir}/man1/*.1*
%{_mandir}/man5/*.5**
/usr/share/doc/mono/*

%files devel
%defattr(-, root, root)
%{_libdir}/*a
%{_libdir}/*.so
%{_libdir}/pkgconfig/mono.pc
%{_datadir}/mono
%{_includedir}/mono

