%define orgver	6.8.4
%define jpver	3.05
%define momorel	3

%define mhlibdir	%{_prefix}/lib/mh
%define _defaultbindir	%{_prefix}/bin

# set these variables to unordinary values,
# since configure script of MH does odd things :-<
%define _bindir		%{_prefix}/bin/mh
%define _libexecdir	%{mhlibdir}

Summary:  MH mail handling system
Name: mh
Version: %{orgver}.%{jpver}
Release: %{momorel}m
License: see "READ-ME.JP"
Url: http://www.chem.eng.himeji-tech.ac.jp/~hayashi/internet/mh-plus.html
Group: Applications/Internet
%NoSource 0 ftp://ftp.chem.eng.himeji-tech.ac.jp/pub/net/mh/mh-%{orgver}-JP-%{jpver}.tar.gz 2f307cfb49969cb7ec1d1db78a276507
Patch0: mh-6.8.4-JP-3.02-glibc.patch
Patch1: mh-for_nfs.patch
Patch2: ftp://ftp.chem.eng.himeji-tech.ac.jp/pub/net/mh/mh-%{orgver}-JP-%{jpver}-patch/mh-%{orgver}-JP-%{jpver}-20030114.patch.gz
Patch3: mh-6.8.4-JP-3.05-errno.patch
Requires: pager
BuildRequires: ncurses-devel
BuildRequires: readline-devel
BuildRoot: %{_tmppath}/%{name}-%{version}-root

%description 
MH mail handling system (with POP support).  MH is a popular
mail handling system but includes only a command line interface.  It is
an important base, however, for programs like xmh and exmh.

%prep 
%setup -q -n %{name}-%{orgver}-JP-%{jpver}
%patch0 -p1 -b .glibc~
%patch1 -p0 -b .fornfs~
%patch2 -p0 -b .repl~
%patch3 -p0 -b .errno~

%build
%configure --enable-batchmode --enable-smtp \
--enable-sharedlib --with-pager=%{_defaultbindir}/pager
%undefine _smp_mflags
%make

%install
rm -rf %{buildroot}

%__mkdir_p %{buildroot}%{mhlibdir}
%makeinstall DESTDIR=%{buildroot} MANDIR=%{buildroot}%{_mandir}

chmod a+x %{buildroot}%{_libdir}/libmh.so*

find %{buildroot}%{mhlibdir} -type f -perm -111 |\
    sed 's,%{buildroot},,' > files.mhlibdir

mkdir -p %{buildroot}/etc/profile.d
echo "export PATH=\$PATH:/usr/bin/mh" > %{buildroot}/etc/profile.d/mh.sh
echo "set path=(\$path /usr/bin/mh)" > %{buildroot}/etc/profile.d/mh.csh
chmod 755 %{buildroot}/etc/profile.d/mh.sh
chmod 755 %{buildroot}/etc/profile.d/mh.csh

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files -f files.mhlibdir
%defattr(-,root,root)
%doc READ-ME FAQ CHANGES doc-JP
%config %{_sysconfdir}/profile.d/*
%dir %{_bindir}
%{_bindir}/*
%{_libdir}/libmh.so*
%dir %{mhlibdir}
%config %{mhlibdir}/mtstailor
%config %{mhlibdir}/MailAliases
%config %{mhlibdir}/components
%config %{mhlibdir}/*comps
%config %{mhlibdir}/mhl.*
%config %{mhlibdir}/scan.*
%config %{mhlibdir}/mhn_defaults
%{mhlibdir}/tmac.h
%{_mandir}/man*/*
/usr/share/man/ja/man*/*bz2

%changelog
* Tue Nov  4 2003 KOMATSU Shinichiro <koma2@momonga-linux.org>
- (6.8.4.3.05-3m)
- adapt the License: preamble for the Momonga Linux license
  expression unification policy (draft)

* Sat Jul 26 2003 KOMATSU Shinichiro <koma2@momonga-linux.org>
- (6.8.4.3.05-2m)
- add mh-6.8.4-JP-3.05-errno.patch to fix build against glibc-2.3
- add ncurses-devel, readline-devel to BuildRequires:

* Mon Jul 21 2003 KOMATSU Shinichiro <koma2@momonga-linux.org>
- (6.8.4.3.05-1m)
- update to 6.8.4-JP-3.05
- heavily modify specfile...
  (use %%configure, %%make, %%makeinstall macros,
   use wildcard in %%files section, etc...)
- use %%NoSource
- set default pager to "pager" and add Requires: pager
- remove setuid bit from inc

* Fri Jun 29 2001 Toru Hoshina <toru@df-usa.com>
- (6.8.4-16k)
- add alphaev5 support.

* Sun Dec  3 2000 MATSUDA, Daiki <dyky@df-usa.com>
- (6.8.4-14k)
- modified spec file with macro to smart

* Thu Jul  6 2000 AYUHANA Tomonori <l@kondara.org>
- (6.8.4_jp-12k)
- mh-for_nfs.patch (for NFS inc)
- add -b at %patch
- add * at man pages

* Fri May 12 2000 AYUHANA Tomonori <l@kondara.org>
- SPEC fixed ( BuildRoot )
- add -q at %setup

* Thu Feb 24 2000 Shingo Akagaki <dora@kondara.org>
- check spec file

* Sat Dec 11 1999 Shingo Akagaki <dora@kondara.org>
- fix spec file

* Sun Nov 7 1999 Toru Hoshina <t@kondara.org>
- be a NoSrc :-P

* Sun Oct 10 1999 Norihito Ohmori <ohmori@flatout.org>
- update mh-6.8.4-JP-3.03

* Wed Sep 29 1999 Norihito Ohmori <ohmori@flatout.org>
- fix alpha compilation bug (by Toru Hoshina)

* Wed Aug 26 1999 Norihito Ohmori <ohmori@flatout.org>
- apply glibc-2.1.x patch
- fix pick -search bug (19990309)
- fix (hencode(trim{subject})) core dump bug (19990611)
- fix long From: core dump bug (19990806)
- disable rpop

* Thu May 13 1999 Jun Nishii <jun@flatout.org>
- merged patch for rpop

* Tue Mar 13 1999 Daisuke SUZUKI <daisuke@linux.or.jp>
- updated to mh-6.8.4-JP3.02

* Tue Jan 19 1999 Daisuke SUZUKI <daisuke@linux.or.jp>
- updated to mh-6.8.4-JP3.01

* Tue Aug 18 1998 Daisuke SUZUKI <daisuke@linux.or.jp>
- added a patch to configure script for PentiumPRO/PentiumII

* Mon Aug 17 1998 Daisuke SUZUKI <daisuke@linux.or.jp>
- added MH-JP patch
