%define lib_name sigc++-1.0

Summary: The Typesafe Signal Framework for C++
Name: libsigc++1
Version: 1.0.4
Release: 4k
License: LGPL
Source: ftp://download.sourceforge.net/pub/sourceforge/libsigc/libsigc++-%version.tar.gz
Url: http://libsigc.sourceforge.net/
Group: System Environment/Libraries
BuildRoot: %{_tmppath}/%{name}-%{version}-root
NoSource: 0

%description
This library implements a full callback system for use in widget libraries,
abstract interfaces, and general programming. Originally part of the Gtk--
widget set, %name is now a seperate library to provide for more general
use. It is the most complete library of its kind with the ablity to connect
an abstract callback to a class method, function, or function object. It
contains adaptor classes for connection of dissimilar callbacks and has an
ease of use unmatched by other C++ callback libraries.

gtk--, starting with version 1.1.2, uses %name.

%package devel
Summary: development tools for the Typesafe Signal Framework for C++ 
Group: Development/Libraries
Requires: %name = %version

%description devel
The %name-devel package contains the static libraries and header files
needed for development with %name.

%prep
%setup -q -n libsigc++-%{version}
perl -pi -e 's|\${prefix}|%{_prefix}|' README
perl -pi -e 's|PREFIX|%{_prefix}|' doc/FAQ

%build
if [ ! -x configure ]; then
  CFLAGS="%{optflags}" CXXFLAGS="%{optflags}" ./autogen.sh --prefix=%{_prefix}
else
  CFLAGS="%{optflags}" CXXFLAGS="%{optflags}" ./configure --prefix=%{_prefix}
fi
%make

%install
rm -rf %{buildroot}
mkdir -p -m 755 %{buildroot}%{_prefix}/{{include,lib}/%lib_name}
make install INSTALL="%(which install) -p" prefix=%{buildroot}%{_prefix}

cp -a examples tests %{buildroot}%{_prefix}/lib/%lib_name
find %{buildroot}%{_prefix}/lib/%lib_name -type f|xargs file|fgrep relocatable|cut -d: -f1|xargs rm -f
find %{buildroot}%{_prefix}/lib/%lib_name -type f|xargs file|fgrep executable|cut -d: -f1|xargs rm -f
find %{buildroot}%{_prefix}/lib/%lib_name -type f|xargs file|fgrep 'shell script'|cut -d: -f1|xargs rm -f
find %{buildroot}%{_prefix}/lib/%lib_name -type d -name .libs|xargs rm -rf

for i in %{buildroot}%{_prefix}/lib/%lib_name/examples/Makefile %{buildroot}%{_prefix}/lib/%lib_name/tests/*/Makefile; do
	rm -f $i.*
	cp -p scripts/examples.Makefile $i
done
for i in %{buildroot}%{_prefix}/lib/%lib_name/tests/Makefile; do
	rm -f $i.*
	cp -p scripts/tests.Makefile $i
done

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%clean
rm -rf %{buildroot}

%files
%defattr(-,root,root)
%attr(755,root,root) %{_libdir}/lib*.so.*
%doc AUTHORS COPYING.LIB README IDEAS NEWS ChangeLog TODO
/usr/share/aclocal/sigc++.m4

%files devel
%defattr(-,root,root)
%{_bindir}/*
%{_prefix}/include/*
%dir %{_libdir}/%lib_name
%{_libdir}/%lib_name/include
#%{_datadir}/aclocal/*
%attr(755,root,root) %{_libdir}/lib*.so
%attr(644,root,root) %{_libdir}/*.*a
%doc doc/*
%{_libdir}/%lib_name/examples
%{_libdir}/%lib_name/tests

%changelog
* Fri Apr 19 2002 Shingo Akagaki <dora@kondara.org>
- (1.0.4-4k)
- rename from libsigc++
- remove example package

* Tue Mar 12 2002 Kazuhiko <kazuhiko@kondara.org>
- (1.0.4-2k)

* Tue Aug  7 2001 Toru Hoshina <toru@df-usa.com>
- (1.0.3-4k)
- no more ifarch alpha.

* Tue Mar 20 2001 Shingo Akagaki <dora@kondara.org>
- version 1.0.3
- K2K

* Tue Oct 17 2000 Tsutomu Yasuda <tom@digitalfactory.co.jp>
- update to 1.0.1

* Wed Jul 05 2000 Toru Hoshina <t@kondara.org>
- rebuild against glibc-2.1.90, X-4.0, rpm-3.0.5.

* Thu Jun 29 2000 Toru Hoshina <t@kondara.org>
- rebild against g++ 2.96.

* Wed May  3 2000 Koichi Asano <koichi@comm.info.eng.osaka-cu.ac.jp>
- to be no source

* Wed Jan 19 2000 Dmitry V. Levin <ldv@fandra.org>
- minor attr fix
- removed unnecessary curly braces
- fixed Herbert's adjustement

* Sat Jan 15 2000 Dmitry V. Levin <ldv@fandra.org>
- minor package dependence fix

* Sat Dec 25 1999 Herbert Valerio Riedel <hvr@gnu.org>
- fixed typo of mine
- added traditional CUSTOM_RELEASE stuff
- added SMP support

* Thu Dec 23 1999 Herbert Valerio Riedel <hvr@gnu.org>
- adjusted spec file to get tests.Makefile and examples.Makefile from scripts/

* Fri Oct 22 1999 Dmitry V. Levin <ldv@fandra.org>
- split into three packages: %name, %name-devel and %name-examples

* Thu Aug 12 1999 Karl Nelson <kenelson@ece.ucdavis.edu>
- updated source field and merged conflicts between revisions.

* Tue Aug 10 1999 Dmitry V. Levin <ldv@fandra.org>
- updated Prefix and BuildRoot fields

* Thu Aug  5 1999 Herbert Valerio Riedel <hvr@hvrlab.dhs.org>
- made sure configure works on all alphas

* Wed Jul  7 1999 Karl Nelson <kenelson@ece.ucdavis.edu>
- Added autoconf macro for sigc.

* Fri Jun 11 1999 Karl Nelson <kenelson@ece.ucdavis.edu>
- Made into a .in to keep version field up to date 
- Still need to do release by hand

* Mon Jun  7 1999 Dmitry V. Levin <ldv@fandra.org>
- added Vendor and Packager fields

* Sat Jun  5 1999 Dmitry V. Levin <ldv@fandra.org>
- updated to 0.8.0

* Tue Jun  1 1999 Dmitry V. Levin <ldv@fandra.org>
- initial revision
