%define momorel 1

Summary: GnuCash is an application to keep track of your finances.
Name: gnucash

Version: 1.8.8
Release: %{momorel}m
License: GPL
Group: Applications/Productivity
%NoSource 0 http://www.gnucash.org/pub/gnucash/sources/stable/gnucash-%{version}.tar.gz 6a68e1517cfab40869fd7151b71457ee
Requires: gnome-libs
PreReq: guile info umb-scheme
BuildRequires: swig
#BuildPrereq: Guppi-devel >= 0.40.3
BuildPrereq: g-wrap-devel >= 1.3.3
BuildPrereq: guile-devel >= 1.3.4
BuildPrereq: gtkhtml-devel >= 1.0.1
BuildPrereq: libglade1-devel >= 0.16
BuildPrereq: gnome-print-devel >= 0.31
BuildPrereq: postgresql-devel >= 7.1.3
BuildPrereq: gal1-devel >= 0.19
BuildPrereq: libghttp-devel
URL: http://www.gnucash.org/
BuildRoot: %{_tmppath}/%{name}-%{version}-root

%description
GnuCash is a personal finance manager. A check-book like
register GUI allows you to enter and track bank accounts,
stocks, income and even currency trades. The interface is
designed to be simple and easy to use, but is backed with
double-entry accounting principles to ensure balanced books.

%prep
%setup -q

%build
automake-old
%configure --enable-sql --disable-guppi
export SED="%__sed" EGREP="%__grep -E" LTCC='gcc' max_cmd_len=32768
make

%install
rm -rf %{buildroot}
export SED="%__sed" EGREP="%__grep -E" LTCC='gcc' max_cmd_len=32768
%makeinstall

%clean
rm -rf %{buildroot}

%post
/sbin/ldconfig
guile -c "(use-modules (ice-9 slib)) (require 'new-catalog)"
/sbin/install-info --info-dir=%{_infodir} \
  --entry="* gnucash-design: (gnucash-design).                  Personal Finance Manager." \
 %{_infodir}/gnucash-design.info.*

%preun
/sbin/ldconfig
if [ $1 = 0 ]; then
/sbin/install-info --delete --info-dir=%{_infodir} \
  --entry="* gnucash-design: (gnucash-design).                  Personal Finance Manager." \
  %{_infodir}/gnucash-design.info.*
fi

%changelog
* Mon Dec 15 2003 Masayuki SANO <sano@acs.i.kyoto-u.ac.jp>
- (1.8.8-1m)
- update to 1.8.8

* Tue Jul  8 2003 Kimitake Shibata <cipher@da2.so-net.ne.jp>
- (1.8.1-4m)
  for libtool

* Mon Mar 10 2003 Tsutomu Yasuda <tom@tom.homelinux.org>
- (1.8.1-3m)
  rebuild against openssl 0.9.7a

* Sat Mar  8 2003 TABUCHI Takaaki <tab@momonga-linux.org>
- (1.8.1-2m)
- add URL tag

* Tue Feb 11 2003 Tsutomu Yasuda <tom@tom.homelinux.org>
- (1.8.1-1m)
  update to 1.8.1

* Fri Feb  7 2003 Tsutomu Yasuda <tom@tom.homelinux.org>
- (1.8.0-1m)
  update to 1.8.0

* Thu Jan 23 2003 Shingo Akagaki <dora@kitty.dnsalias.org>
- (1.6.8-2m)
- rebuild against for postgresql

* Fri Oct 11 2002 Shingo Akagaki <dora@kitty.dnsalias.org>
- (1.6.8-1m)
- version 1.6.8

* Wed Jul  3 2002 Kazuhiko <kazuhiko@fdiary.net>
- (1.6.6-2m)
- add 'BuildPrereq: libghttp-devel'

* Wed Jun 12 2002 Shingo Akagaki <dora@kondara.org>
- (1.6.6-2k)
- version 1.6.6

* Sun Jun 02 2002 Toru Hoshina <t@kondara.org>
- (1.6.5-6k)
- gtkhtml is still needed.

* Thu Mar 14 2002 Shingo Akagaki <dora@kondara.org>
- (1.6.5-4k)
- disable guppi

* Wed Dec 26 2001 MATSUDA, Daiki <dyky@df-usa.com>
- (1.6.5-2k)
- update to 1.6.5

* Fri Dec 14 2001 Shingo Akagaki <dora@kondara.org>
- (1.6.4-20k)
- rebuild against gtkhtml-1.0.0

* Thu Nov 22 2001 Shingo Akagaki <dora@kondara.org>
- (1.6.4-18k)
- rebuild against Guppi 0.40.2

* Sun Oct 28 2001 Toru Hoshina <t@kondara.org>
- (1.6.4-12k)
- rebuild against postgresql 7.1.3-4k.

* Sun Oct 28 2001 MATSUDA, Daiki <dyky@df-usa.com>
- (1.6.4-10k)
- add umb-scheme to PreReq tag

* Sat Oct 27 2001 Toru Hoshina <t@kondara.org>
- (1.6.4-8k)
- rebuild against postgresql 7.1.3.

* Thu Oct 25 2001 Shingo Akagaki <dora@digitalfactory.co.jp>
- (1.6.4-6k)
- rebuild against for gtkhtml-0.15.0

* Wed Oct 17 2001 Toru Hoshina <t@kondara.org>
- (1.6.4-4k)
- rebuild against gettext 0.10.40.

* Tue Oct  2 2001 MATSUDA, Daiki <dyky@df-usa.com>
- (1.6.4-2k)
- update to 1.6.4

* Tue Aug 28 2001 Shingo Akagaki <dora@digitalfactory.co.jp>
- (1.6.1-10k)
- add patches from RawHide
- rebuild against fro gnome-print-0.29

* Wed Aug 22 2001 Shingo Akagaki <dora@digitalfactory.co.jp>
- rebuild against for gtkhtml-0.11.1

* Mon Aug 20 2001 MATSUDA, Daiki <dyky@df-usa.com>
- (1.6.1-6k)
- correct %post and %preun behavior for info

* Fri Aug 17 2001 MATSDUA, Daiki <dyky@df-usa.com>
- (1.6.1-4k)
- import from Jirai

* Thu May  3 2001 MATSUDA, Daiki <dyky@df-usa.com>
- (1.4.12-2k)
- update to 1.4.12

* Mon Apr 16 2001 MATSUDA, Daiki <dyky@df-usa.com>
- (1.4.10-4k)
- errase %ttr(555,-,-) again

* Sat Apr  7 2001 Shingo Akagaki <dora@kondara.org>
- (1.4.10-3k)
- version 1.4.10

* Tue Jan 16 2001 Kenichi Matsubara <m@kondara.org>
- (1.4.9-5k)
- /usr/man to %{_mandir}.
- %attr(555,-,-) /usr/bin/gnucash to /usr/bin/gnucash
- %attr(555,-,-) /usr/bin/gnc-prices to /usr/bin/gnc-prices

* Sun Jan 14 2001 MATSUDA, Daiki <dyky@df-usa.com>
- (1.4.9-3k)
- Kondarization

%files
%defattr(-,root,root)
%doc AUTHORS COPYING ChangeLog NEWS README
%doc doc/README.german doc/README.francais doc/guile-hackers.txt
%config %{_sysconfdir}/gnucash
%{_bindir}/*
%{_libdir}/lib*
%{_libdir}/gnucash
%{_mandir}/man1/*
%{_infodir}/*info*
%{_datadir}/mime-info/*
%{_datadir}/gnome/apps/Applications/gnucash.desktop
%{_datadir}/pixmaps/gnucash
%{_datadir}/locale/*/LC_MESSAGES/gnucash.mo
%{_datadir}/gnucash
%{_libexecdir}/gnucash
%{_includedir}/gnucash
/usr/share/aclocal/gnucash.m4
/usr/share/info/dir
