%global __libtoolize : 
%global nokerberos: yes 
%global momorel 2

%{!?docs: %global docs 1}

Summary: LPRng Print Spooler
Name: LPRng
Version: 3.8.23
Release: %{momorel}m
License: GPL or Artistic
Group: System Environment/Daemons
# %%NoSource 0 ftp://ftp.lprng.com/pub/LPRng/LPRng/%{name}-%{version}.tgz 76fece34112bd40e049b9beb1ff9cab2
Source0: ftp://ftp.lprng.com/pub/LPRng/LPRng/%{name}-%{version}.tgz
Source1: lpd.init
Patch0: LPRng-3.7.4-kerb5.patch
Patch3: LPRng-3.8.4-nonblock.patch
URL: http://www.lprng.com/
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Obsoletes: lpr
Provides: lpr
Prereq: chkconfig, mktemp, fileutils, textutils, gawk
%{!?nokerberos:BuildPrereq: krb5-devel}
%{!?nokerberos:Requires: krb5-libs}
BuildRequires: openssl-devel
BuildRequires: tcp_wrappers
BuildPreReq: gettext

# We don't ship these files, but create symlinks to them. Other
# packages aren't to know though.
Provides: %{_bindir}/lp
Provides: %{_bindir}/lpq
Provides: %{_bindir}/lpr
Provides: %{_bindir}/lprm
Provides: %{_bindir}/lpstat
Provides: %{_bindir}/cancel
Provides: %{_sbindir}/lpc

%description
The LPRng software is an enhanced, extended, and portable implementation
of the Berkeley LPR print spooler functionality. While providing the
same interface and meeting RFC1179 requirements, the implementation
is completely new and provides support for the following features:
lightweight (no databases needed) lpr, lpc, and lprm programs; dynamic
redirection of print queues; automatic job holding; highly verbose
diagnostics; multiple printers serving a single queue; client programs
do not need to run SUID root; greatly enhanced security checks; and a
greatly improved permission and authorization mechanism.

The source software compiles and runs on a wide variety of UNIX systems,
and is compatible with other print spoolers and network printers that
use the LPR interface and meet RFC1179 requirements.  LPRng provides
emulation packages for the SVR4 lp and lpstat programs, eliminating the
need for another print spooler package. These emulation packages can be
modified according to local requirements, in order to support vintage
printing systems.

For users that require secure and/or authenticated printing support,
LPRng supports Kerberos V, MIT Kerberos IV Print Support, and PGP
authentication.  LPRng is being adopted by MIT for use as their Campus
Wide printing support system. Additional authentication support is
extremely simple to add.

%package docs
Summary: LPRng documentations
Group: Documentation

%description docs
"LPRng HOWTO" and "Printing Cookbook"

%prep
%setup -q
%{!?nokerberos:%patch0 -p1 -b .kerb5}
%patch3 -p1 -b .nonblock~

# set up gettext
cd po
rm Makefile.in.in
ln -s /usr/share/gettext/po/Makefile.in.in .
cd ..
#rm -fr intl
    
%build
%configure --enable-nls \
    --enable-shared \
    --disable-static \
    --with-userid=lp \
    --with-groupid=lp \
    --disable-gdbm \
    --disable-setuid \
    --enable-tcpwrappers \
    --enable-ssl \
%{!?nokerberos:    --enable-kerberos}
%make

%install
rm -rf %{buildroot}

make DESTDIR=%{buildroot} POSTINSTALL=no install
install -m755 src/monitor %{buildroot}%{_sbindir}/monitor

# install init script
mkdir -p %{buildroot}%{_initscriptdir}
install -m755 %{SOURCE1} %{buildroot}%{_initscriptdir}/lpd

# install config files
mkdir -p %{buildroot}%{_sysconfdir}/lpd
install -m644 lpd.conf lpd.perms %{buildroot}%{_sysconfdir}/lpd

# Adjust defaults
cat << EOF >> %{buildroot}%{_sysconfdir}/lpd/lpd.conf
#
# do not open port by default
lpd_listen_port=off
ipp_listen_port=off
EOF

#cat << EOF | ed %{buildroot}%{_sysconfdir}/lpd.conf
#/default mc=/a
#mc#128
#.
#wq
#EOF

%clean
rm -rf %{buildroot}

%post
/sbin/chkconfig --add lpd
if [ -w /etc/printcap ] ; then
  TMP1=`mktemp /etc/printcap.XXXXXX`
  gawk '
    BEGIN { first = 1; cont = 0; last = "" }
    /^[:space:]*#/	{ if(cont) sub("\\\\$", "", last)}
    { if(first == 0) print last }
    { first = 0 }
    { last = $0 }
    { cont = 0 }
    /\\$/ { cont = 1 }
    END {sub("\\\\$", "", last); print last}
  ' /etc/printcap > ${TMP1} && cat ${TMP1} > /etc/printcap && rm -f ${TMP1}
fi

%preun
if [ "$1" = 0 ]; then
  %{_initscriptdir}/lpd stop >/dev/null 2>&1
  /sbin/chkconfig --del lpd
fi

%postun
if [ "$1" -ge "1" ]; then
  %{_initscriptdir}/lpd condrestart >/dev/null 2>&1
fi

%files
/usr/lib/liblpr.la
/usr/share/locale/fr/LC_MESSAGES/LPRng.mo
%defattr(-,root,root)
%attr(644,root,root) %config(noreplace) %{_sysconfdir}/lpd/lpd.conf
%attr(644,root,root) %config(noreplace) %{_sysconfdir}/lpd/lpd.perms
%config %{_initscriptdir}/lpd
%{_libdir}/*.so*
%{_bindir}/*
%{_sbindir}/*
%dir %{_libexecdir}/filters
%{_libexecdir}/filters/*
%{_mandir}/*/*
%doc CHANGES CONTRIBUTORS COPYRIGHT INSTALL LICENSE 
%doc README* VERSION Y2KCompliance

%if %docs
%files docs
%defattr(-,root,root)
%doc DOCS PrintingCookbook
%endif

%changelog
* Mon Nov 24 2003 TABUCHI Takaaki <tab@momonga-linux.org>
- (3.8.23-2m)
- tmp No NoSource: 0
- tarball on ftp server is broken.

* Mon Nov 24 2003 KOMATSU Shinichiro <koma2@momonga-linux.org>
- (3.8.23-1m)
- update to 3.8.23
- remove LPRng-3.8.20-fix-localedir.patch and LPRng-3.8.21-unused-function.patch
- use %%make and %%NoSource
- do not open printer port (515) by default
- It seems that LPRng >= 3.8.23 listens to ipp port (631) by default
  (it's not functional, though).
  So, add "ipp_listen_port=off" to lpd.conf and disable this behaviour.

* Sun Jul 20 2003 YAMAZAKI Makoto <uomaster@nifty.com>
- (3.8.21-3m)
- remove unused function 'log' which conflicts builtin function prototype

* Sat Jul 19 2003 kourin <kourin@fh.freeserve.ne.jp>
- (3.8.21-2m)
- libtoolize

* Wed Apr 16 2003 KOMATSU Shinichiro <koma2@momonga-linux.org>
- (3.8.21-1m)
- update to 3.8.21 which contains a security fix for psbannar.
  http://www.debian.org/security/2003/dsa-285

* Wed Mar  5 2003 Tsutomu Yasuda <tom@tom.homelinux.org>
- (3.8.20-2m)
  rebuild against openssl 0.9.7a

* Wed Feb 12 2003 KOMATSU Shinichiro <koma2@momonga-linux.org>
- (3.8.20-1m)
- update to 3.8.20
- install PrintingCookbook (as separate package)
- fix owner/group of executables

* Sun Jun 30 2002 Kazuhiko <kazuhiko@fdiary.net>
- (3.8.12-2m)
- revise %doc files

* Thu Jun 13 2002 Tsutomu Yasuda <tom@kondara.org>
- (3.8.12-2k)
  update to 3.8.12
  fix permitions

* Sat Apr  6 2002 Kenta MURATA <muraken@kondara.org>
- (3.8.10-4k)

* Sat Apr  6 2002 Kenta MURATA <muraken@kondara.org>
- (3.8.10-2k)

* Sun Oct 14 2001 Masaru Sato <masachan@kondara.org>
- Modify BuildRoot

* Sun Jun 17 2001 Toru Hoshina <toru@df-usa.com>
- (3.7.21-24k)

* Thu Jun 07 2001 Crutcher Dunnavant <crutcher@redhat.com>
- setgroups droping patch

* Thu Mar 29 2001 Crutcher Dunnavant <crutcher@redhat.com>
- told checkpc to only Check_file() job files. (keeping it from zapping the master-filter)

* Fri Mar  9 2001 Crutcher Dunnavant <crutcher@redhat.com>
- applied elliot's patch (which i got idependently from the lprng list as well)
- that fixes a thinko that killed LPRng on 64 arches.

* Fri Mar  9 2001 Crutcher Dunnavant <crutcher@redhat.com>
- fixed the URLs for the LPRng project

* Thu Mar  8 2001 Crutcher Dunnavant <crutcher@redhat.com>
- reverted the shutdown call in Local_job to make device filters work.
- all your base are belong to us

* Wed Mar 07 2001 Philipp Knirsch <pknirsch@redhat.de>
- Removed the shutdown patch for common/linksupport:Link_close() as ii
generated a deadlock between lpr and lpd for none existing printers.

* Wed Mar  7 2001 MATSUDA, Daiki <dyky@df-usa.com>
- (3.6.21-14k)
- rebuild against disable ipv6 environment

* Sun Feb 25 2001 Crutcher Dunnavant <crutcher@redhat.com>
- hacked out the shutdown(sock, 1) calls that killed stupid network printers.

* Wed Feb 15 2001 Crutcher Dunnavant <crutcher@redhat.com>
- tweak to ldp.init's display messages

* Fri Feb  9 2001 Crutcher Dunnavant <crutcher@redhat.com>
- man page tweak

* Thu Feb  8 2001 Crutcher Dunnavant <crutcher@redhat.com>
- (yet) further tweaks to lpd.init's display format.

* Tue Feb  6 2001 Crutcher Dunnavant <crutcher@redhat.com>
- further tweaks to lpd.init's display format.

* Tue Feb  6 2001 Crutcher Dunnavant <crutcher@redhat.com>
- cleaned up lpd.init to do translations correctly, and stop screwing up
- result values.

* Thu Feb  1 2001 Crutcher Dunnavant <crutcher@redhat.com>
- added lpd init back (ick!)

* Wed Jan 24 2001 Crutcher Dunnavant <crutcher@redhat.com>
- removed req for printconf (It should go the other way)

* Thu Jan 18 2001 Crutcher Dunnavant <crutcher@redhat.com>
- fixed file list

* Thu Jan 18 2001 Crutcher Dunnavant <crutcher@redhat.com>
- removed lpd.init, set requirement of printconf

* Thu Jan 11 2001 Crutcher Dunnavant <crutcher@redhat.com>
- upgraded to LPRng-3.7.4

* Tue Dec 12 2000 Crutcher Dunnavant <crutcher@redhat.com>
- rebuild for kerb

* Tue Nov 28 2000 Toru Hoshina <toru@df-usa.com>
- use _initscriptdir macro to keep backword compatibility.

* Mon Oct 23 2000 Crutcher Dunnavant <crutcher@redhat.com>
- Upgraded to LPRng-3.6.26
- Removed syslog patch, as .24 fixes the problem

* Wed Sep 27 2000 Motonobu Ichimura <famao@kondara.org>
- fixed secutiry hole
- See "http://www.securityfocus.com/frames/?content=/templates/archive.pike%3Ffromthread%3D0%26threads%3D0%26mid%3D85002%26list%3D1%26end%3D2000-09-30%26start%3D2000-09-24%26"

* Mon Sep 25 2000 Crutcher Dunnavant <crutcher@redhat.com>
- Patched use_syslog to avoid a format string exploit.
- Resolves bug #17756

* Sat Sep 23 2000 Toru Hoshina <t@kondara.org>
- merge from pinstripe.
- rebuild without krb5.

* Mon Sep 18 2000 Crutcher Dunnavant <crutcher@redhat.com>
- Upgraded to LPRng-3.6.24

* Mon Sep 11 2000 Crutcher Dunnavant <crutcher@redhat.com>
- Added gettext to the BuildPreReq list

* Mon Sep 11 2000 Crutcher Dunnavant <crutcher@redhat.com>
- Fixed lpd.init to use /etc/rc.d/init.d/, instead of /etc/init.d

* Mon Sep 11 2000 Crutcher Dunnavant <crutcher@redhat.com>
- changed the prereq: /etc/init.d to: /etc/rc.d/init.d
- we are not changing that over (yet?)

* Mon Aug 14 2000 Crutcher Dunnavant <crutcher@redhat.com>
- removed the sticky bit from lpc

* Mon Aug 14 2000 Crutcher Dunnavant <crutcher@redhat.com>
- removed the sticky bit from the client programs (LPRng doesn't need them)

* Sat Aug 05 2000 Bill Nottingham <notting@redhat.com>
- condrestart fixes

* Fri Aug  4 2000 Bill Nottingham <notting@redhat.com>
- triggerpostun on lpr

* Sun Jul 30 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- 3.6.22 (some fixes)

* Tue Jul 25 2000 Bill Nottingham <notting@redhat.com>
- fix prereq

* Sat Jul 22 2000 Nalin Dahyabhai <nalin@redhat.com>
- fix bogus checkpc error messages when the lockfile doesn't exist because
  init scripts clear /var/run (#14472)

* Tue Jul 18 2000 Nalin Dahyabhai <nalin@redhat.com>
- fix chkconfig comments in the init script

* Mon Jul 17 2000 Nalin Dahyabhai <nalin@redhat.com>
- move the init script to /etc/rc.d/init.d
- fix perms on setuid binaries

* Fri Jul 14 2000 Nalin Dahyabhai <nalin@redhat.com>
- patch checkpc to not complain when filter is executable and in the
  spool directory
- remove --disable-force_localhost from configure invocation for better
  compatibility with BSD LPR and rhs-printfilters
- change group back to lp, which is what printtool expects

* Thu Jul 13 2000 Nalin Dahyabhai <nalin@redhat.com>
- change default group to 'daemon' to match 6.2
- enable NLS support
- remove Prefix: tag
- break init script out into a separate file
- fix up broken printcaps in post-install
- run checkpc -f at start-time

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Tue Jul 11 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- 3.6.21
- get rid of the notypedef patch - gcc has been fixed at last.

* Mon Jun 26 2000 Preston Brown <pbrown@redhat.com>
- sample config files removed from /etc.
- initscript moved to /etc/init.d

* Wed Jun 21 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- 3.6.18

* Sat Jun 17 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- 3.6.16
- adapt Kerberos and fixmake patches
- get rid of CFLAGS="-O"; gcc has been fixed
- fix build with glibc 2.2

* Mon Jun 05 2000 Preston Brown <pbrown@redhat.com>
- ifdef 0 is illegal, changed to if 0.
- work around compiler typdef bug.

* Thu Jun 01 2000 Preston Brown <pbrown@redhat.com>
- start, stop, and restart are functions not switch statements now.
  reduces overhead.
- patch to allow autoconf to choose which user/group to run as

* Wed May 31 2000 Preston Brown <pbrown@redhat.com>
- remove init.d symbolic links.
- remove txt/ps/info versions of the HOWTO from the pkg
- use new fhs paths

* Thu May 25 2000 Nalin Dahyabhai <nalin@redhat.com>
- change free() to krb5_free_data_contents() when patching for Kerberos 5
- detect libcrypto or libk5crypto when looking for Kerberos 5

* Tue May 16 2000 Nalin Dahyabhai <nalin@redhat.com>
- enable Kerberos support
- remove extra defattr in files list
- add --disable-force_localhost to configure invocation
- remove "-o root" at install-time

* Tue May 16 2000 Matt Wilson <msw@redhat.com>
- add Prereq of /sbin/chkconfig
- fix broken conflicting declaration on alpha

* Tue Apr 18 2000 Bernhard Rosenkraenzer <bero@redhat.com>
- initial Red Hat packaging, fix up the spec file

* Mon Sep 13 1999 Patrick Powell <papowell@astart.com>
- resolved problems with symbolic links to /etc/init.d
  files - used the chkconfig facility

* Sat Sep  4 1999 Patrick Powell <papowell@astart.com>
- did ugly things to put the script in the spec file

* Sat Aug 28 1999 Giulio Orsero <giulioo@tiscalinet.it>
- 3.6.8

* Fri Aug 27 1999 Giulio Orsero <giulioo@tiscalinet.it>
- 3.6.7 First RPM build.
